/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.IItemListModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.DynamicTreesSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

public class BuildingLumberjack
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> REPLANT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "replant"));
    public static final ISettingKey<BoolSetting> RESTRICT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "restrict"));
    public static final ISettingKey<DynamicTreesSetting> DYNAMIC_TREES_SIZE = new SettingKey<DynamicTreesSetting>(DynamicTreesSetting.class, new ResourceLocation("minecolonies", "dynamictreeharvestsize"));
    private static final String TAG_RESTRICT_START = "startRestrictionPosition";
    private static final String TAG_RESTRICT_END = "endRestrictionPosition";
    private BlockPos startRestriction = null;
    private BlockPos endRestriction = null;
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String LUMBERJACK = "lumberjack";
    private final Set<BlockPos> netherTrees = new HashSet<BlockPos>();
    private static final int FUNGI_MODIFIER = 10;

    public BuildingLumberjack(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHEARS, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        IItemListModule saplingList = this.getModuleMatching(ItemListModule.class, m -> m.getId().equals("saplings"));
        for (ItemStorage sapling : IColonyManager.getInstance().getCompatibilityManager().getCopyOfSaplings()) {
            if (saplingList.isItemInList(sapling)) continue;
            toKeep.put(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(sapling.getItemStack(), stack), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
        }
        return toKeep;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.startRestriction = compound.func_150296_c().contains(TAG_RESTRICT_START) ? NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(TAG_RESTRICT_START)) : null;
        this.endRestriction = compound.func_150296_c().contains(TAG_RESTRICT_END) ? NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(TAG_RESTRICT_END)) : null;
        ListNBT netherTreeBinTagList = compound.func_150295_c("netherTrees", 10);
        for (int i = 0; i < netherTreeBinTagList.size(); ++i) {
            this.netherTrees.add(BlockPosUtil.readFromListNBT(netherTreeBinTagList, i));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.startRestriction != null) {
            compound.func_218657_a(TAG_RESTRICT_START, (INBT)NBTUtil.func_186859_a((BlockPos)this.startRestriction));
        }
        if (this.endRestriction != null) {
            compound.func_218657_a(TAG_RESTRICT_END, (INBT)NBTUtil.func_186859_a((BlockPos)this.endRestriction));
        }
        @NotNull ListNBT netherTreeBinCompoundList = new ListNBT();
        for (BlockPos pos : this.netherTrees) {
            BlockPosUtil.writeToListNBT(netherTreeBinCompoundList, pos);
        }
        compound.func_218657_a("netherTrees", (INBT)netherTreeBinCompoundList);
        return compound;
    }

    public boolean shouldReplant() {
        return this.getSetting(REPLANT).getValue();
    }

    public boolean shouldRestrict() {
        if (this.getSetting(RESTRICT).getValue() && (this.startRestriction == null || this.endRestriction == null)) {
            this.getSetting(RESTRICT).trigger();
            this.markDirty();
        }
        return this.getSetting(RESTRICT).getValue();
    }

    public void setRestrictedArea(BlockPos startPosition, BlockPos endPosition) {
        this.startRestriction = startPosition;
        this.endRestriction = endPosition;
    }

    public BlockPos getStartRestriction() {
        return this.startRestriction;
    }

    public BlockPos getEndRestriction() {
        return this.endRestriction;
    }

    private void bonemealFungi() {
        WorkerBuildingModule module = this.getFirstModuleOccurance(WorkerBuildingModule.class);
        ICitizenData data = this.getFirstModuleOccurance(WorkerBuildingModule.class).getFirstCitizen();
        if (data == null) {
            return;
        }
        int modifier = Math.max(0, Math.min(10, 100));
        Iterator<BlockPos> iterator = this.netherTrees.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            World world = this.colony.getWorld();
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) continue;
            BlockState blockState = world.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block == Blocks.field_235382_mv_ || block == Blocks.field_235373_mm_) {
                IGrowable growable;
                int threshold = modifier + (int)Math.ceil((float)data.getCitizenSkillHandler().getLevel(module.getPrimarySkill()) * (1.0f - (float)modifier / 100.0f));
                int rand = world.func_201674_k().nextInt(100);
                if (rand >= threshold || !(growable = (IGrowable)block).func_176473_a((IBlockReader)world, pos, blockState, world.field_72995_K) || world.field_72995_K || !growable.func_180670_a(world, world.field_73012_v, pos, blockState)) continue;
                growable.func_225535_a_((ServerWorld)world, world.field_73012_v, pos, blockState);
                return;
            }
            iterator.remove();
        }
    }

    public Set<BlockPos> getNetherTrees() {
        return new HashSet<BlockPos>(this.netherTrees);
    }

    public void removeNetherTree(BlockPos pos) {
        this.netherTrees.remove(pos);
    }

    public void addNetherTree(BlockPos pos) {
        this.netherTrees.add(pos);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        this.bonemealFungi();
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canRecipeBeAdded(@NotNull IToken<?> token) {
            return false;
        }
    }
}

